#define LIGHTING
#define NONORMAL
#include "InventorBasicEffectDx9.fxh"

struct VSPos
{
	float3 Pos			: Position;
};

//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------

VSOutput VS_Pos( VSPos Input)
{
	VSOutput Out = (VSOutput) 0;
	float4 LocalPos = float4(Input.Pos,1.0f);

	Out.Pos = mul(LocalPos, g_matWorldViewProj);
	
	float3 ViewPos = mul(LocalPos, g_matWorldView);    //position in view space
	if(g_enabledLight)
	{
		float Opacity = g_Misc.y;
		TripleColor Color = CalcLightingAmb(Input.Pos,g_Emissive, g_Ambient,Opacity);
		Out.ColorD = Color.Diffuse;
	}else
	{
		Out.ColorD = g_Emissive;
	}
	Out.ColorD.w = g_Misc.y;

#ifdef DIFFUSE_TEXTURE
	Out.Tex += float4(Input.Pos*(g_texCoordType == TEX_COORD_POSITION), 1.0f);
	Out.Tex += float4(ViewPos * (g_texCoordType == TEX_COORD_CAMERASPACEPOSITION), 0);
	Out.Tex = mul(Out.Tex, g_matDiffTex);
#endif

	if(g_fogEnabled)
	{
		Out.ColorSAndFogFactor.w = CalcFogFactor(ViewPos.z);
	}

#ifdef FIX_Z
	Out.Pos.z = 0.205f;//always visible
#endif
	return Out;
}

//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------

float4 PS_Pos( PSInput Input ) : COLOR0
{
#ifdef DIFFUSE_TEXTURE
	CalcDiffuseTexture(Input);
#endif	
	if(Input.ColorD.a < g_Misc.w)
		discard;
	float4 Color=(float4)0;
	Color.xyz = saturate(Input.ColorD.xyz + Input.ColorSAndFogFactor.xyz);
	Color.a = Input.ColorD.a;

	if(g_fogEnabled)
	{
		float FogFactor = Input.ColorSAndFogFactor.w;
		return FogFactor * Color + (1.0 - FogFactor) * g_fogColor;
	}
	else
		return Color;
}

//--------------------------------------------------------------------------------------
// Techniques
//--------------------------------------------------------------------------------------

technique Pos
{
    pass P0
    {   
#ifdef SHADERMODEL2
		VertexShader = compile vs_2_0 VS_Pos();
		PixelShader = compile ps_2_0 PS_Pos();
#else
		VertexShader = compile vs_2_a VS_Pos();
		PixelShader = compile ps_2_a PS_Pos();
#endif
    }
}